# Welcome Screen

The Welcome screen is the starting point of EasyStatistics. From here you can open a dataset, resume a saved project, access help, or tweak app settings.

![Welcome screen showing “Open File” and “Open Project”](assets/welcome.png)

## What you see

- **Center buttons**
  - **Open File** — load a new dataset or project file. Supported formats:
    - `.csv` — Comma-separated values
    - `.xls` — Legacy Excel spreadsheets
    - `.xlsx` — Modern Excel spreadsheets
    - `.rtf` — Rich Text Format (for data tables)
    - `.estats` — EasyStatistics project files
    - `*.*` — All files (not recommended unless you know the format is supported)
  - **Open Project** — resume a previously saved EasyStatistics project, restoring your data, variable types, and generated results (same as open `.estats` file). 

- **Top-left**
  - **App & Version label** — shows the application name and current version (useful when reporting issues).

- **Top-right**
  - **Help** — opens the offline documentation (this site).
  - **Settings** (gear icon) — opens application preferences (theme/UI options, default data directory, plotting settings, etc.).

> 💡 Tip: If you’re unsure, start with a **CSV** file — it’s the most universally supported format.  
> Or try out our <a href="assets/demo.csv" target="_blank" download>demo.csv</a> dataset to quickly explore the app’s features.


## Quick start

1. Click **Open File** and select your dataset (CSV, Excel, RTF, or project file).
2. Wait for the brief loading notice; you’ll land on **Data Summary**.
3. Review variables and adjust types if needed, then move on to **Quick Statistics** or **Custom Statistics**.

## Common actions

- **Accidentally opened the wrong file/project?**  
  Use **File → Open** from the top menu bar to choose another.

- **First time here?**  
  Open the **Help** from the top-right to see tutorials and examples.
