# Wilcoxon Signed-Rank Test

The **Wilcoxon Signed-Rank Test** is a **non-parametric paired difference test**, used when the assumptions of the Paired T-Test are violated.

It evaluates whether the **median difference** between paired observations is zero.

Examples:
- Before/after measurements  
- Matched pairs  
- Repeated measures with only 2 conditions  

---

# 📌 When to Use
Use Wilcoxon when:
- You have **paired** data  
- The **distribution of differences is not normal**  
- Data is **ordinal** or **non-normally distributed continuous**  
- You want a non-parametric alternative to the Paired T-Test  

---

# 📐 Simple Test Procedure

Given paired scores $(X_i, Y_i)$:

1. Compute differences:
   $d_i = Y_i - X_i$

2. Remove pairs where $d_i = 0$

3. Rank $|d_i|$ from smallest to largest  
   (ties get average ranks)

4. Attach the sign of $d_i$  
   - If $d_i > 0$ → positive rank  
   - If $d_i < 0$ → negative rank  

5. Compute:
   - $W^+$ = sum of positive ranks  
   - $W^-$ = sum of negative ranks  

6. Test statistic:
   $$
   W = \min(W^+, W^-)
   $$

---

# 🔬 Worked Example

Before:  3,  5,  6  
After:   5,  8,  7  

Differences:

| Pair | Before | After | d_i   | \|d_i\| | Rank  | Signed Rank |
|------|--------|-------|-------|---------|-------|-------------|
| 1    | 3      | 5     |  2    | 2       | 2     | +2          |
| 2    | 5      | 8     |  3    | 3       | 3     | +3          |
| 3    | 6      | 7     |  1    | 1       | 1     | +1          |

Compute sums:

- $W^+ = 1 + 2 + 3 = 6$  
- $W^- = 0$

Test statistic:

$$
W = \min(6, 0) = 0
$$

A very small $W$ suggests strong evidence of change.

---

# 🧪 Assumptions
- Paired observations  
- Differences are symmetrically distributed  
- Data at least ordinal  
- No huge outliers in paired differences  

---

# 🧩 Advanced Math (Optional)

For larger samples, $W$ is approximated by a normal distribution:

$$
Z = \frac{W - \frac{n(n+1)}{4}}{\sqrt{\frac{n(n+1)(2n+1)}{24}}}
$$

EasyStatistics automatically switches to the correct method (exact or normal approximation).

---

# 🧠 Interpretation

- If the test is significant →  
  There is a **systematic median shift** between paired measurements.

EasyStatistics also reports:
- Signed rank sums  
- Exact or asymptotic p-value  
- Direction of change  
- Interpretation text  

---

# 🐍 Python Implementation

SciPy:
https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.wilcoxon.html

```python
from scipy.stats import wilcoxon

w, p = wilcoxon(before, after, alternative='two-sided')
print("W =", w, "p =", p)
```
# 📎 Related Tests
[Paired T-Test](/statistics/ttests/ttest-paired.md)

[Mann–Whitney U Test](/statistics/ttests/mann-whitney.md)

[Friedman Test](/statistics/anova/friedman.md)

[Repeated Measures ANOVA](/statistics/anova/repeated-anova.md)