# Paired Samples T-Test

The **Paired T-Test** compares means from **two related samples** (e.g., before/after).

---

# 📌 When to Use
- Same participants measured twice  
- Continuous dependent variable  
- Differences are approximately normal  

---

# 📐 Simple Formula

$$
t = \frac{\bar{d}}{s_d / \sqrt{n}}
$$

Where:
- $d$ = paired differences  
- $\bar{d}$ = mean difference  
- $s_d$ = SD of differences  

---

# 🔬 Example

Before: 5, 7, 6  
After: 8, 9, 7  

Differences: 3, 2, 1  
Mean difference:
$$
\bar{d} = 2
$$

SD of differences:
$$
s_d = 1
$$

Test statistic:
$$
t = \frac{2}{1 / \sqrt{3}} = 3.46
$$

---

# 🧪 Assumptions
- Normality of differences  
- Observations paired  

---

# 🧠 Interpretation
Significant t → meaningful change over time.

EasyStatistics outputs:
- t  
- p  
- Cohen’s d for paired samples  

---

# 🐍 Python Implementation

SciPy:
https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.ttest_rel.html

```python
from scipy.stats import ttest_rel

t, p = ttest_rel(before, after)
print("t =", t, "p =", p)
```
# 📎 Related Tests
[Independent Samples T-Test](/statistics/ttests/ttest-independent.md)

[Wilcoxon Signed-Rank Test](/statistics/ttests/wilcoxon.md)

[Repeated Measures ANOVA](/statistics/anova/repeated-anova.md)