# Independent Samples T-Test

The **Independent Samples T-Test** compares the means of **two independent groups** on a continuous outcome.

---

# 📌 When to Use
- Two groups (independent)  
- Continuous dependent variable  
- Roughly normal distribution  
- Variances equal or not (EasyStatistics auto-detects and applies Welch's correction if needed)

---

# 📐 Simple Formula

For equal variances:

$$
t = \frac{\bar{X}_1 - \bar{X}_2}
         {s_p \sqrt{\frac{1}{n_1} + \frac{1}{n_2}}}
$$

Where pooled SD:

$$
s_p = \sqrt{
\frac{(n_1 - 1)s_1^2 + (n_2 - 1)s_2^2}
     {n_1 + n_2 - 2}
}
$$

Welch’s version (auto-applied when variances differ):

$$
t = \frac{\bar{X}_1 - \bar{X}_2}
         {\sqrt{\frac{s_1^2}{n_1} + \frac{s_2^2}{n_2}}}
$$

---

# 🔬 Example

Group A: 10, 12, 9  
Group B: 20, 18, 17  

Means:
- A: $10.33$  
- B: $18.33$  

Pooled SE (simplified):
$$
SE \approx 2.52
$$

Test statistic:
$$
t = \frac{10.33 - 18.33}{2.52} = -3.17
$$

---

# 🧪 Assumptions
- Normal distribution  
- Independent observations  
- Equal variances if using pooled version (Welch adjusts)

---

# 🧠 Interpretation
A large $|t|$ indicates the means differ significantly.  

EasyStatistics provides:
- t-statistic  
- p-value  
- effect size (Cohen’s d)  
- interpretation  

---

# 🐍 Python Implementation

SciPy:
https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.ttest_ind.html

Used in EasyStatistics:
```python
from scipy.stats import ttest_ind
t, p = ttest_ind(a, b, equal_var=False)
```
# 📎 Related Tests
[Paired T-Test](/statistics/ttests/ttest-paired.md)

[Mann–Whitney U Test](/statistics/ttests/mann-whitney.md)