# Mann–Whitney U Test

A **non-parametric alternative** to the independent t-test.  
Tests whether two groups differ in distribution.

---

# 📌 When to Use
- Two independent groups  
- Data not normal  
- Ordinal or skewed data  

---

# 📐 Simple Formula (Rank-Based)

All values are ranked; U is computed as:

$$
U = n_1 n_2 + \frac{n_1 (n_1 + 1)}{2} - R_1
$$

Where $R_1$ is the sum of ranks of group 1.

---

# 🔬 Example

Group A: 1, 3  
Group B: 2, 4  

Ranks: 1, 2, 3, 4  

Group A ranks = 1 + 3 = 4  
Then:

$$
U = 2\cdot 2 + \frac{2\cdot 3}{2} - 4 = 4 + 3 - 4 = 3
$$

---

# 🧠 Interpretation
U is compared to critical values or converted to a p-value.

---

# 🐍 Python Implementation
SciPy:
https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.mannwhitneyu.html
```python
from scipy.stats import mannwhitneyu
u, p = mannwhitneyu(group1, group2, alternative='two-sided')
print("U =", u, "p =", p)
```
# 📎 Related Tests
[Independent Samples T-Test](/statistics/ttests/ttest-independent.md)

[Wilcoxon Signed-Rank Test](/statistics/ttests/wilcoxon.md)

[Kruskal–Wallis Test](/statistics/anova/kruskal-wallis.md)