# Statistical Tests in EasyStatistics

Welcome to the statistical reference guide for **EasyStatistics**.


This section provides:

- An overview of all supported tests  
- When to use each test  
- Short descriptions  
- Links to the full detailed pages  
- Notes on assumptions, post-hoc comparisons, and corrections  

EasyStatistics automatically performs:

- **Post-hoc pairwise comparisons** (when applicable)
- **Bonferroni correction** to control the family-wise error rate
- Appropriate **parametric or non-parametric** methods depending on the data

---

## 📂 Categories of Tests

### **Categorical Tests**
- [Chi-Square Test](categorical/chi-square.md)

### **Two-Group Comparisons**
- [Independent Samples T-Test](ttests/ttest-independent.md)  
- [Paired T-Test](ttests/ttest-paired.md)  
- [Mann–Whitney U Test](ttests/mann-whitney.md)

### **ANOVA Family**
- [One-Way ANOVA](anova/one-way-anova.md)
- [Two-Way ANOVA](anova/two-way-anova.md)
- [Repeated Measures ANOVA](anova/repeated-anova.md)
- [ANCOVA](anova/ancova.md)
- [MANOVA](anova/manova.md)
- [Kruskal–Wallis Test](anova/kruskal-wallis.md)
- [Friedman Test](anova/friedman.md)

### **Correlation Tests**
- [Pearson Correlation](correlation/pearson.md)
- [Spearman Correlation](correlation/spearman.md)
- [Partial Pearson Correlation](correlation/partial-pearson.md)
- [Partial Spearman Correlation](correlation/partial-spearman.md)

### **Regression Models**
- [Simple Linear Regression](regression/simple-linear.md)
- [Multiple Linear Regression](regression/multiple-linear.md)
- [Multiple Logistic Regression](regression/logistic.md)
- [Multinomial Logistic Regression](regression/multinomial-logistic.md)

### **Survival Analysis**
- [Kaplan–Meier Survival Analysis](survival/kaplan-meier.md)

### **Predictor Selection**
- [Automatic Predictor Selection](predictors/auto-predictor-selection.md)

---

## 🧠 Understanding Post-Hoc Tests & Bonferroni Correction

Some tests require follow-up comparisons after the main test determines that groups differ.

EasyStatistics automatically performs:

### **Post-hoc Methods**
- Tukey HSD (for ANOVA)
- Dunn's Test (for Kruskal–Wallis)
- Wilcoxon Signed-Rank Pairwise (for Friedman)
- Paired/Independent t-tests where applicable
- Mann–Whitney pairwise comparisons

### **Bonferroni Correction**
Applied automatically: 

$p_{\text{corrected}} = p_{\text{raw}} \times m$

Where:

- \( m \) = number of comparisons  
- Ensures the family-wise error rate is controlled  
---

## 📘 How to Use This Guide

Each detailed page contains:

- What the test does  
- When to use it  
- Math overview (simple)  
- **Advanced math section**
- Assumptions  
- Numeric example  
- Post-hoc & Bonferroni  
- Python library reference  
- Interpretation  

Use the sidebar to browse the tests.

