# Partial Spearman Correlation

The **Partial Spearman correlation** measures the **rank-based monotonic relationship** between two variables while **controlling for covariates**.

It is robust against:
- Non-normality  
- Outliers  
- Non-linear monotonic relationships  

---

# 📌 When to Use
Use when:
- You want to control for covariates  
- Data is ordinal or non-normal  
- Relationship is monotonic  

---

# 📐 Formula (Conceptual)

1. Convert X, Y, and controls to ranks  
2. Compute residuals after regressing ranks on control variables  
3. Compute Pearson correlation of the residuals  

---

# 🔬 Numerical Flow Example

Let:
- X, Y = variables of interest  
- Z = control variable  

Steps:
1. Rank X, Y, Z  
2. Compute residuals:
   - $ X' = X_{\text{rank}} - \hat{X}_{\text{rank}}(Z) $
   - $ Y' = Y_{\text{rank}} - \hat{Y}_{\text{rank}}(Z) $
3. Then:
$$
\rho_{XY \cdot Z} = \text{Pearson}(X', Y')
$$

---

# 🧪 Assumptions
- Monotonic relation  
- Z must be numeric or ordinal  

---

# 🧠 Interpretation
Interpretation is identical to Spearman ρ, but controlling for Z.

---

# 🐍 Python Implementation

Pingouin:
https://pingouin-stats.org/generated/pingouin.partial_corr.html

EasyStatistics uses:
```python
pg.partial_corr(data=df, x='X', y='Y', covar='Z', method='spearman')
```
# 📎 Related Tests
[Spearman Correlation](statistics/correlation/spearman.md)

[Partial Pearson Correlation](statistics/correlation/partial-pearson.md)
  