# Partial Pearson Correlation

The **Partial Pearson correlation** measures the relationship between **two variables** while **controlling for one or more additional variables**.

Example:
- Relationship between height and weight controlling for age.

---

# 📌 When to Use
Use when:
- You want correlation **excluding the influence** of one or more covariates  
- Data is continuous and approximately normal  

---

# 📐 Formula (Simple)

Partial correlation between X and Y controlling for Z:

$$
r_{XY \cdot Z} = \frac{ r_{XY} - r_{XZ} r_{YZ} }
                      { \sqrt{(1 - r_{XZ}^2)(1 - r_{YZ}^2)} }
$$

---

# 📎 Advanced Math (Matrix Form)


Let $ R $ be the correlation matrix of all variables and $ P = R^{-1} $ its inverse (the precision matrix).  
Then the partial correlation between variables $i$ and $j$, controlling for all other variables, is:

$$
r_{ij\cdot \text{others}} = - \frac{P_{ij}}{\sqrt{P_{ii} P_{jj}}}
$$

This generalizes to any number of controls.

---

# 🔬 Numerical Example

If:

- $ r_{XY} = 0.8 $  
- $ r_{XZ} = 0.6 $  
- $ r_{YZ} = 0.7 $

Then:

$$
r_{XY \cdot Z}
= \frac{0.8 - 0.6(0.7)}{\sqrt{(1-0.36)(1-0.49)}}
= \frac{0.38}{\sqrt{(0.64)(0.51)}} = 0.67
$$

---

# 🧪 Assumptions
- Normality  
- Linearity  
- No severe outliers  

---

# 🧠 Interpretation
Values are interpreted same as Pearson \(r\), but now represent **unique** linear association.

---

# 🐍 Python Implementation

Pingouin:
https://pingouin-stats.org/generated/pingouin.partial_corr.html

Used in EasyStatistics:
```python
import pingouin as pg
pg.partial_corr(data=df, x='X', y='Y', covar='Z')
```
# 📎 Related Tests
[Pearson Correlation](statistics/correlation/pearson.md)

[Partial Spearman Correlation](statistics/correlation/partial-spearman.md)