# Choosing the Right Statistical Test

Selecting the correct statistical test depends on:

- The type of your dependent variable (numeric or categorical)
- The number of groups
- Whether samples are paired or independent
- Whether assumptions like normality hold

This guide provides a structured decision pathway.

---

# 🎯 Step 1 — Identify Your Dependent Variable Type

## **Is your outcome numeric (continuous)?**
Examples:
- Test scores  
- Reaction time  
- Blood pressure  

If **yes**, go to **Step 2A**.

---

## **Is your outcome categorical (binary or multi-class)?**
Examples:
- Yes/No  
- Disease/No Disease  
- Type of customer  

If **yes**, go to **Step 2B**.

---

# 📊 Step 2A — Numeric Outcome

## **How many groups are you comparing?**

### **2 groups — independent**
Use:
- [Independent Samples T-Test](ttests/ttest-independent.md)
- If non-normal:  
  - [Mann–Whitney U Test](ttests/mann-whitney.md)

---

### **2 groups — paired**
Use:
- [Paired T-Test](ttests/ttest-paired.md)
- If non-normal:
  - [Wilcoxon Signed-Rank Test](anova/friedman.md)  
  *(Friedman is for ≥3 time points; Wilcoxon is used for pairwise)*

---

### **3 or more groups — independent**
Use:
- [One-Way ANOVA](anova/one-way-anova.md)
- If non-normal:
  - [Kruskal–Wallis](anova/kruskal-wallis.md)

Post-hoc & Bonferroni applied automatically.

---

### **3 or more groups — repeated measures**
Use:
- [Repeated Measures ANOVA](anova/repeated-anova.md)
- If non-normal:
  - [Friedman Test](anova/friedman.md)

---

# 👥 Step 2B — Categorical Outcome

### **Binary outcome**
Use:
- [Multiple Logistic Regression](regression/logistic.md)
- For classification + predictors

---

### **Outcome with 3+ categories**
Use:
- [Multinomial Logistic Regression](regression/multinomial-logistic.md)

---

# 🔗 Step 3 — Relationships Between Variables

### Both numeric?
- [Pearson Correlation](correlation/pearson.md)
- If non-normal:
  - [Spearman Correlation](correlation/spearman.md)

### Numeric variables controlling others?
- [Partial Pearson](correlation/partial-pearson.md)
- [Partial Spearman](correlation/partial-spearman.md)

---

# 🔮 Step 4 — Prediction / Modeling

### Predict numeric outcome?
- [Multiple Linear Regression](regression/multiple-linear.md)

### Predict binary outcome?
- [Logistic Regression](regression/logistic.md)

### Predict multi-class outcome?
- [Multinomial Logistic Regression](regression/multinomial-logistic.md)

### Automatically find best predictors?
- [Automatic Predictor Selection](predictors/auto-predictor-selection.md)

---

# 🕒 Step 5 — Time-to-Event Data

Use:
- [Kaplan–Meier Survival Analysis](survival/kaplan-meier.md)

---

# ✔ Summary Decision Tree

```text
Start
 ├─ Is the dependent variable numeric?
 │    ├─ Comparing 2 groups?
 │    │     ├─ Independent groups → Independent Samples T-Test
 │    │     │                          or Mann–Whitney U (non-parametric)
 │    │     └─ Paired groups → Paired T-Test
 │    │                          or Wilcoxon Signed-Rank (non-parametric)
 │    │
 │    ├─ Comparing 3 or more groups?
 │    │     ├─ Independent groups → One-Way ANOVA
 │    │     │                          or Kruskal–Wallis (non-parametric)
 │    │     └─ Repeated measures → Repeated Measures ANOVA
 │    │                               or Friedman Test (non-parametric)
 │    │
 │    └─ Predicting a numeric outcome? → Multiple Linear Regression
 │
 └─ Is the dependent variable categorical?
      ├─ Binary outcome → Logistic Regression
      ├─ 3+ categories → Multinomial Logistic Regression
      ├─ Relationship between two categorical variables? → Chi-Square Test
      └─ Predicting categories? → Logistic / Multinomial Regression

