# Two-Way ANOVA

Two-Way ANOVA evaluates:
- Main effect of **Factor A**
- Main effect of **Factor B**
- **Interaction** between A and B

---

# 📌 When to Use
- Two categorical independent variables  
- One continuous dependent variable  
- Independent groups  

---

# 📐 Model

$$
Y = \mu + A + B + AB + \varepsilon
$$

Where:
- $A$: effect of factor A  
- $B$: effect of factor B  
- $AB$: interaction  

---

# 🔬 Example Question
Do **Teaching Method** and **Gender** each affect test score?  
Does the **effect of method depend on gender**?

---

# 🧩 Post-Hoc Tests (Auto)
- Tukey HSD for each factor  
- Bonferroni corrections  

---

# 🧪 Assumptions
- Normality  
- Homogeneity of variances  
- Independent samples  

---

# 🧠 Interpretation
Three possible conclusions:
- Factor A has an effect  
- Factor B has an effect  
- A×B interaction exists (most important)

---

# 🐍 Python Implementation

Statsmodels:
https://www.statsmodels.org/stable/anova.html

```python
import statsmodels.api as sm
from statsmodels.formula.api import ols

model = ols('Y ~ C(A) * C(B)', data=df).fit()
anova_table = sm.stats.anova_lm(model, typ=2)
print(anova_table)
```
# 📎 Related Tests

[One-Way ANOVA](/statistics/anova/one-way-anova.md)

[Repeated Measures ANOVA](/statistics/anova/repeated-anova.md)

[ANCOVA](/statistics/anova/ancova.md)

