# Repeated Measures ANOVA

Repeated Measures ANOVA analyzes **within-subject differences** across 3 or more conditions or timepoints.

---

# 📌 When to Use
- Same subjects in all conditions  
- Continuous dependent variable  
- Want to measure change across time or conditions  

---

# 📐 Conceptual Model

Decomposes variance into:
- Between-subject variance  
- Within-subject variance  
- Condition (treatment) effect  
- Residual error  

---

# 🔬 Example Question
Did performance change across **baseline**, **mid**, and **post** conditions?

---

# 🧪 Assumptions
- Sphericity (equal covariances)  
- Normality  
- Repeated measurements on same subjects  

EasyStatistics automatically:
- Tests sphericity  
- Reports Greenhouse–Geisser correction if needed  

---

# 🧩 Post-Hoc Tests
- Pairwise paired t-tests  
- Bonferroni correction  

---

# 🐍 Python Implementation

Statsmodels AnovaRM:
https://www.statsmodels.org/stable/generated/statsmodels.stats.anova.AnovaRM.html

```python
from statsmodels.stats.anova import AnovaRM

anova = AnovaRM(df, 'score', 'subject', within=['condition']).fit()
print(anova)
```

# 📎 Related Tests
[Friedman Test](/statistics/anova/friedman.md)

[Paired T-Test](/statistics/ttests/ttest-paired.md)

[One-Way ANOVA](/statistics/anova/one-way-anova.md)

