# MANOVA (Multivariate ANOVA)

MANOVA tests group differences across **multiple dependent variables** simultaneously.

---

# 📌 When to Use
- You have more than one continuous outcome  
- Groups are categorical  
- You want to test **multivariate** differences  

---

# 📐 Core Statistic

Wilks’ Lambda:

$$
\Lambda = \frac{|\mathbf{W}|}{|\mathbf{W} + \mathbf{B}|}
$$

Where:
- $\mathbf{W}$ = within-group SSCP matrix  
- $\mathbf{B}$ = between-group SSCP matrix  

Small $\Lambda$ → strong group differences.

---

# 🔬 Example
Comparing groups on **height + weight** together.

---

# 🧪 Assumptions
- Multivariate normality  
- Homogeneity of covariance matrices  
- Independent samples  

---

# 🧠 Interpretation
MANOVA reveals whether groups differ across multiple outcomes.  
Follow-up univariate ANOVAs show *which* dependent variables differ.

---

# 🐍 Python Implementation

Statsmodels MANOVA:
https://www.statsmodels.org/stable/generated/statsmodels.multivariate.manova.MANOVA.html

```python
from statsmodels.multivariate.manova import MANOVA

mv = MANOVA.from_formula('height + weight ~ group', data=df)
print(mv.mv_test())
```

# 📎 Related Tests

[ANCOVA](/statistics/anova/ancova.md)

[One-Way ANOVA](/statistics/anova/one-way-anova.md)

[Two-Way ANOVA](/statistics/anova/two-way-anova.md)