# Kruskal–Wallis Test

The **Kruskal–Wallis Test** is the non-parametric equivalent of One-Way ANOVA.

It evaluates differences between **three or more independent groups** based on ranks.

---

# 📌 When to Use
- ≥ 3 independent groups  
- Ordinal or skewed data  
- Non-normal distributions  

---

# 📐 Formula

$$
H =
\frac{12}{N(N+1)}
\sum \frac{R_i^2}{n_i}
- 3(N+1)
$$

Where:
- $R_i$ = rank sum for group i  
- $n_i$ = sample size for group i  

---

# 🔬 Example
EasyStatistics computes:
- H statistic  
- p-value  
- Rank table  

---

# 🧩 Post-Hoc Tests (Auto)
- Dunn’s pairwise tests  
- Bonferroni correction  

---

# 🧪 Assumptions
- Independent groups  
- Ordinal or continuous non-normal data  
- Similar distribution shapes  

---

# 🐍 Python Implementation

SciPy:
https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.kruskal.html

```python
from scipy.stats import kruskal

h, p = kruskal(group1, group2, group3)
print("H =", h, "p =", p)
```

# 📎 Related Tests

[One-Way ANOVA](/statistics/anova/one-way-anova.md)

[Kruskal–Wallis Test](/statistics/anova/kruskal-wallis.md)

[Mann–Whitney U Test](/statistics/ttests/mann-whitney.md)

