# Friedman Test

The **Friedman Test** is the non-parametric equivalent of Repeated Measures ANOVA.

Used for comparing **three or more related samples**.

---

# 📌 When to Use
- Repeated measurements  
- Ordinal or non-normal data  
- 3+ conditions  

---

# 📐 Formula

$$
\chi^2_F = 
\frac{12}{n k (k+1)}
\sum R_j^2
- 3n(k+1)
$$

Where:
- $k$ = number of conditions  
- $n$ = number of subjects  
- $R_j$ = rank sums  

---

# 🔬 Example
EasyStatistics provides:
- $\chi^2_F$  
- p-value  
- Rank matrix  

---

# 🧩 Post-Hoc Tests (Auto)
- Wilcoxon Signed-Rank pairwise tests  
- Bonferroni correction  

---

# 🧪 Assumptions
- Repeated measures  
- Data ordinal or continuous  
- Differences need not be normal  

---

# 🐍 Python Implementation

SciPy:
https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.friedmanchisquare.html

```python
from scipy.stats import friedmanchisquare

stat, p = friedmanchisquare(cond1, cond2, cond3)
print("Friedman chi2 =", stat, "p =", p)
```
# 📎 Related Tests
[Repeated Measures ANOVA](/statistics/anova/repeated-anova.md)

[Wilcoxon Signed-Rank Test](/statistics/ttests/wilcoxon.md)

[Kruskal–Wallis Test](/statistics/anova/kruskal-wallis.md)
