# ANCOVA (Analysis of Covariance)

ANCOVA combines:
- ANOVA (categorical groups)
- Regression (continuous covariates)

---

# 📌 When to Use
- Compare group means  
- **Adjust** for continuous covariates (e.g., pre-test score)  

---

# 📐 Model

$$
Y = \beta_0 + \beta_1 X + \tau G + \varepsilon
$$

Where:
- $X$: covariate  
- $G$: group  
- $\tau$: adjusted group difference  

---

# 🔬 Example
Compare post-test scores between teaching methods **controlling for pre-test score**.

---

# 🧪 Assumptions
- Linearity  
- Homogeneity of regression slopes  
- Normality  
- Equal variances  

---

# 🧠 Interpretation
ANCOVA tells you whether groups differ **after adjusting** for covariates.

---

# 🐍 Python Implementation

Statsmodels:
https://www.statsmodels.org/stable/regression.html

```python
import statsmodels.api as sm
from statsmodels.formula.api import ols

model = ols('post ~ pre + C(method)', data=df).fit()
anova_table = sm.stats.anova_lm(model, typ=2)
print(anova_table)
```

# 📎 Related Tests

[One-Way ANOVA](/statistics/anova/one-way-anova.md)

[Two-Way ANOVA](/statistics/anova/two-way-anova.md)

[MANOVA](/statistics/anova/manova.md)

