# Saving, Loading, and Exporting Results

This page explains how to **export statistics**, **save projects**, **load saved analyses**, and **export images** generated by the app.  
These options are available in **Quick Statistics**, **Custom Statistics**, and the main workspace.

---

## Exporting Statistics

You can export results generated by:

- **Descriptive Statistics**
- **Quick Statistics**
- **Custom Statistics**

All exported files include:

- The full textual output  
- Tables (e.g., ANOVA tables, regression tables, pairwise comparisons)  
- Interpretation text  
- Metadata (date, dataset name, test type)

Supported formats:

- **.docx** — fully formatted Word document (default)  
- **PDF** — *coming soon*  


---

## Exporting Descriptive Statistics

Descriptive Statistics offers two export modes:

### **1. Export All**
Exports descriptive statistics for **all variables** in the dataset.

### **2. Export Selected**
Exports only the variables chosen using:

- The **search bar**, or  
- The **filter filter buttons** (numeric, categorical, text, etc.)

Both options generate a **.docx** file.

--- 

## Exporting Statistical Test Results (Quick & Custom Statistics)

When running **Quick Statistics** or **Custom Statistics**, all generated results appear as separate blocks in the results panel.

Use:

- **Export Stats** — exports **all statistical results currently listed** in the results panel.

### How exporting works

1. When you click **Export Stats**, you must choose a **folder** (not a file).  
2. The app will automatically create one or more `.docx` files inside that folder.

### File batching (important!)

If you have many statistical results:

- Each `.docx` file contains **up to 100 statistics**.
- If more than 100 results exist, the exporter will automatically create multiple files.

Example:

- `stat_results_1.docx` — contains statistics 1–100  
- `stat_results_2.docx` — contains statistics 101–200  
- `stat_results_3.docx` — and so on  

This ensures large analysis sessions remain manageable and files don’t grow excessively large.

---

## Exporting Images (Plots)

All visualizations (plots and charts) can be exported separately from the statistics.

Supported image formats:

- **PNG**  
- **JPG**  
- **SVG** (vector format, best for publications)  
- **PDF**  

### How to export a plot

1. Run any test that includes a plot (ANOVA, regression, MANOVA, etc.).  
2. In the **plot area**, use the **Export Plot** button, then click **Export**.  
3. Choose your preferred image format.  

> 💡 **Tip:** Use **SVG** or **PDF** for high-quality print or publication.  
> PNG/JPG is ideal for PowerPoint or documentation.

---

## Saving a Project

A project contains:

- Loaded dataset  
- All selected statistics  
- All generated results  
- Test configuration  
- Plots (linked, not embedded)  
- Predictor selections  
- Custom Statistics selections  

Projects are stored in a single file:

**`<name>.estats`**

### How to save a project

1. From the main window, click **Save Project**.  
2. Choose a location and a filename.  
3. A `.estats` project file is created.

---

## Loading a Saved Project

There are **two ways** to load a project:

### Method 1: Open inside the app
1. Open the app.  
2. Click **Load Project** or **Open File** or **Open**.  
3. Select your `.estats` file.  

### Method 2: Double-click the `.estats` file
- On Windows/macOS/Linux, simply double-click the project file:  
  **`<project_name>.estats`**  
- The app will launch automatically and load the full project.

> ✔ This allows you to share project files with others easily.  
> ✔ Double-clicking restores the entire session exactly as it was.
