# Quick Statistics

The **Quick Statistics** tab automatically explores your dataset by running the most common statistical tests on **all valid combinations of variables**.  
This gives you a quick overview of significant relationships without having to manually set up each test.

![Quick Statistics tab with test results](assets/quick-stats.png)
![Quick Statistics tab with test results](assets/quick-stats2.png)
---

## How it works

- Variable types (continuous, categorical, binary) are **defined in the Data Summary tab**.  
- Quick Statistics then:
  - Uses those types to determine which statistical tests are appropriate.  
  - Runs the tests across all valid combinations of variables.  
  - Displays the results as a list of **result blocks**.  

This makes it easy to discover patterns and significant effects across your dataset in just a few seconds.

---

## Toolbar (filters)

The buttons at the top are **filters** that show only results of a specific test type:

- **Chi-Square Test** — associations between categorical variables.  
- **Mann–Whitney U Test** — non-parametric test for two groups.  
- **T-Test** — mean difference between two groups.  
- **ANOVA** — mean comparison across multiple groups.  
- **Kruskal–Wallis H Test** — non-parametric alternative to ANOVA.  
- **Pearson Correlation Test** — correlation between two continuous variables.  
- **Spearman Correlation Test** — non-parametric correlation measure.  


**Search box**  
  Start typing a variable name and the view updates instantly, showing only matches. 
  > 💡 Useful when interested in all the results regarding a variable.

Other controls:
- **Show only significant** — filter results to display only tests with significant p-values.  
- **Remove Statistic** — delete one result block from the view.  

---

## Result blocks

Each automatically generated result block is divided into two main sections:

- **Left side** — Description & detailed output
  - **Top**: Short description — a plain-language explanation of what the selected test does (e.g., *“The ANOVA test compares the means of multiple groups to check if at least one group mean is significantly different.”*).  
  - **Below**: Full statistical details:
    - Test statistic, degrees of freedom, p-value.  
    - Effect sizes and confidence intervals (when available).  
    - Power analysis (if sample size is low).  
    - Contingency tables or summary tables, depending on the test type.  

- **Right side** — Visual & report
  - **Top**: Plot showing the relationship (e.g., bar chart, mean plot, correlation scatter).  
  - **Bottom**: Report text — automatically generated, ready to copy into papers or reports.  

This structure provides both an explanation (for interpretation) and full technical details (for reporting and validation).

---

## Export options

- **Export displayed QStats** — saves only the results currently visible after applying filters (e.g., only ANOVA results, or only significant results).  
  > Example: If you filter by **T-Test** and enable **Show only significant**, the export will contain only the significant T-Test results.  

- **Export all QStats** — saves every Quick Statistics result for the dataset, ignoring filters.


---

## Quick workflow

1. Define and adjust variable types in **Data Summary**.  
2. Open **Quick Statistics** — analyses run automatically on all valid combinations.  
3. Use the **toolbar filters** to focus on specific types of tests.  
4. Review the result blocks with stats, interpretations, and plots.  
5. Apply **Show only significant** to highlight meaningful results.  
6. Export results or copy report text for further use.  

---

## Tips

- **Variable typing matters**: Double-check your variable types in Data Summary, since Quick Stats relies on them.  
- Use filters to cut through noise and focus only on the test types you care about.  
- Pair **Show only significant** with export options to quickly generate a focused report.  
- For tailored models (e.g., ANCOVA, MANOVA, ROC curves), switch to the **Custom Statistics** tab.  

---

**Next:** [Custom Statistics](custom-stats.md)
