# Data Summary

The **Data Summary** tab gives you a quick overview of your dataset after it is loaded.  
Here you can inspect variables, review descriptive statistics, **define variable types**, and prepare your dataset for analysis.

![Data Summary tab with variables and plots](assets/data-summary.png)

---

## Role of Data Summary

- When you load a dataset, EasyStatistics **automatically detects the type of each variable** (continuous, categorical, binary, or date).  
- These detected types are shown here and can be manually adjusted.  
- The chosen types are then used by:
  - **Quick Statistics** → to decide which statistical test to run between variable combinations.  
  - **Custom Statistics** → to build models correctly.  

> 💡 Always check and confirm variable types here before moving on.  

---

## Layout

- **Top navigation bar**
  - **All** — show every variable.
  - **Continuous** — filter only numeric variables.
  - **Categorical** — filter only categorical factors.
  - **Binary** — filter only binary variables.
  - **Date** — filter date-type variables.

- **Search box**  
  Located above the variable list. Start typing a variable name and the view updates instantly, showing only matches.  
  > 💡 Useful when working with large datasets containing many variables.

- **Variable blocks**
  Each variable in your dataset is displayed as a block containing:
  - **Descriptive statistics**  
    - **Continuous**: N, missing count, mean, SD, median, quartiles, outliers.  
    - **Categorical/Binary**: categories with counts and percentages.  
    - **Date**: number of entries, earliest (first) date, and latest (last) date.
  - **Plot**  
    - Histogram (continuous/date) or bar plot (categorical/binary).  
  - **Controls (buttons at bottom of block)**  
    - **Change to Continuous** — recode categorical → numeric.  
    - **Change to Categorical** — recode numeric → categorical.  
    - **Change to Label** — mark variable as label (not used in analysis).  
    - **Remove Outliers** — exclude detected outliers (continuous only).

- **Export options (top-right corner of tab)**
  - **Export displayed descriptives** — saves only the variables currently visible after applying filters and/or a search.  
    > Example: If you filter by **Continuous** and search for "Age", the export will contain only the descriptive stats for `Age`.  
  - **Export all descriptives** — save statistics for the entire dataset.  

---

## Quick workflow

1. Browse through **All variables** to get a dataset overview.  
2. Use the **tabs (Continuous/Categorical/Binary/Date)** to filter variable types.  
3. Use the **search box** to quickly find variables by name.  
4. Adjust variable types or clean data (e.g., remove outliers).  
5. Export summaries if needed.  
6. Proceed to **Quick Statistics** or **Custom Statistics** — they will use the variable types defined here.  

---

## Tips

- **Variable typing is critical**: Wrong types → wrong tests in Quick Statistics.  
- **Scroll behavior**: Scrolling works only when the mouse is inside the Data Summary panel, avoiding conflicts with the main page.  
- **Variable name cleaning**: Special characters (spaces, `:`, etc.) are auto-cleaned. If duplicates occur, suffixes are added automatically.  
- **Best practice**: Always verify variable types and names here before running analyses.  

---

**Next:** [Quick Statistics](quick-stats.md)
