# Custom Statistics

The **Custom Statistics** tab allows you to manually design and run advanced statistical analyses.  
Unlike **Quick Statistics** (which automatically runs all valid tests), Custom Statistics lets you choose the exact variables and tests you want to perform.

![Custom Statistics tab](assets/custom-stats.png)

---

## Workflow overview

### Specific Statistical Test

1. **Select Variables**  
   - Click **Select Variables** to open the selection dialog.  
   - Choose the variables you want to use for analysis.  
   - Selected variables are shown in the **Selected data** panel (right).  

   > ℹ️ As you add variables, the list of available statistical tests on the right updates.  
   > Only tests that can be applied to your selection (or a subset of it) become available.

2. **Choose a Test**  
   - Once variables are selected, click on a test from the **Statistical analysis panel** (right-hand side).  
   - Examples: ANOVA, MANOVA, Two-Way ANOVA, Kaplan–Meier Analysis, Repeated Measures ANOVA, etc.  
   - A short description appears under the panel, explaining what the test does.  

3. **Configure the Test**  
   - Depending on the selected test, you may need to assign variables to roles (e.g., dependent, independent, grouping, event, time-to-event).  
   - The configuration area appears at the bottom of the dialog.  
   - Example: For **Two-Way ANOVA**, choose one continuous dependent variable and two categorical factors.  

4. **Run the Test**  
   - Click the **Run** button for the chosen test.  
   - The analysis is performed and results appear in the familiar format used in **Quick Statistics**:  
     - **Left side**: Short description + detailed output (tables, p-values, effect sizes, pairwise comparisons).  
     - **Right side**: Plot (top) + report text (bottom).  

---

## Example: Two-Way ANOVA

![Two-Way ANOVA example](assets/custom-stats3.png)

- **Description (top left)**: Explains that Two-Way ANOVA examines the effects of two categorical variables on a continuous outcome, including their interaction.  
- **Detailed results (left)**: ANOVA table with F-values, p-values, and post-hoc pairwise comparisons.  
- **Visualization (right, top)**: Group means with confidence intervals.  
- **Report text (right, bottom)**: A narrative summary suitable for reports, with significant findings highlighted.  

---

## Find Predictor

   The **Find Predictor** feature helps you automatically identify which variables best predict your selected dependent variable.

   - After selecting your dependent variable (DV), you can click **Find Predictor** to automatically discover which variables in your dataset are the most important predictors of that DV.  
   - The system analyses **all remaining variables**, including:  
     - Continuous variables  
     - Binary variables  
     - Categorical factors  
   - A ranked list of predictors is shown, from strongest to weakest.  
   - You may then add the suggested predictors directly into the **Selected data** panel or continue selecting your own variables manually.

   > 💡 **Tip:** Find Predictor is useful when your dataset has many variables and you want guidance on which ones matter most.


### How it works

- Once you choose a **dependent variable**, click **Find Predictor**.  
- The app scans **all other variables** in your dataset and builds an appropriate model:  
  - **Regression models** for numeric outcomes  
  - **Classification models** for categorical outcomes  
- All variable types are supported:  
  - Numeric  
  - Binary  
  - Categorical with multiple levels  
  - Text/string categories (auto-encoded)

### What you get

- A **ranked list of predictors** by importance.  
- You can immediately select and apply those predictors to continue working in Custom Statistics.  
- This feature is extremely helpful for datasets with many potential predictors.

### Notes

- Predictor importance reflects **predictive power**, not necessarily causation.  
- Variables with excessive missing values may be excluded.  
- ID-like columns (e.g., user IDs, nearly-unique timestamps) are ignored to avoid misleading importance scores.

---

## Exporting results

- **Export Stats** — saves the currently displayed test results.  
- **Remove Statistic** — removes the result block from view.  

---

## Key differences from Quick Statistics

- **Quick Statistics** → runs everything automatically across all variable combinations.  
- **Custom Statistics** → you **choose** variables and tests, giving you full control.  
- Suitable for **targeted, hypothesis-driven analyses**.  

---

**Next:** [Saving & Exporting Projects](save_and_export.md)
